#include <iostream>
#include <vector>
#include <algorithm>
#include <ctime>

using namespace std;

int main() {
    int N, M, K, L;
    cin >> N >> M >> K >> L;

    vector<vector<int>> A(N, vector<int>(M));

    for (int i = 0; i < N; ++i) {
        for (int j = 0; j < M; ++j) {
            cin >> A[i][j];
        }
    }

    // Postavljanje generatora slucajnih brojeva
    srand(time(nullptr));

    // Simulirano kaljenje
    long long totalMaxValue = 0;
    vector<vector<int>> bestArrangement = A;

    for (int iter = 0; iter < 1000; ++iter) {
        for (int i = 0; i < N; ++i) {
            random_shuffle(A[i].begin(), A[i].end());  // Nasumicno mešajte elemente u svakom redu matrice
        }

        long long currentTotalValue = 0;
        // Iterirajte kroz sve moguce pocetne tacke podmatrice
        for (int i = 0; i <= N - K; ++i) {
            for (int j = 0; j <= M - L; ++j) {
                long long currentTotalBeauty = 0;
                // Izracunajte ukupnu lepotu za trenutnu podmatricu
                for (int x = i; x < i + K; ++x) {
                    for (int y = j; y < j + L; ++y) {
                        currentTotalBeauty += A[x][y];
                    }
                }
                // Ažurirajte vrednost za trenutnu raspodelu elemenata
                currentTotalValue += currentTotalBeauty;
            }
        }

        // Ako smo pronašli bolju raspodelu, ažurirajte najbolju raspodelu
        if (currentTotalValue > totalMaxValue) {
            totalMaxValue = currentTotalValue;
            bestArrangement = A;
        }
    }

    // Ispisivanje matrice sa najboljom raspodelom
    cout << "Matrica sa najboljom raspodelom:" << endl;
    for (int i = 0; i < N; ++i) {
        for (int j = 0; j < M; ++j) {
            cout << bestArrangement[i][j] << " ";
        }
        cout << endl;
    }

    // Ispisivanje zbir svih maksimalnih vrednosti
    cout << "Zbir svih maksimalnih vrednosti: " << totalMaxValue << endl;

    return 0;
}